/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ExecutableUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.Messages;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public final class ZipUtil {
    private static final int ATTR_SYMLINK = 40960;
    private static final int ERR_CONFLICTS = 128;
    private static final int ERR_NoWritePermission = 130;

    private ZipUtil() {
    }

    public static IStatus extract(File zipFile, File destinationPath, IProgressMonitor monitor) throws IOException {
        if (ZipUtil.canDoNativeUnzip(Conflict.SKIP, null)) {
            return ZipUtil.nativeUnzip(zipFile, destinationPath, Conflict.SKIP, monitor);
        }
        return ZipUtil.extract(new ZipFile(zipFile), destinationPath, monitor);
    }

    public static IStatus extract(File zipFile, File destinationPath, boolean overwrite, IProgressMonitor monitor) throws IOException {
        return ZipUtil.extract(zipFile, destinationPath, overwrite, true, monitor);
    }

    public static IStatus extract(File zipFile, File destinationPath, boolean overwrite, boolean isNative, IProgressMonitor monitor) throws IOException {
        Conflict whatToDo;
        Conflict conflict = whatToDo = overwrite ? Conflict.OVERWRITE : Conflict.SKIP;
        if (ZipUtil.canDoNativeUnzip(whatToDo, null) && isNative) {
            return ZipUtil.nativeUnzip(zipFile, destinationPath, whatToDo, monitor);
        }
        return ZipUtil.extract(new ZipFile(zipFile), destinationPath, overwrite, monitor);
    }

    public static IStatus extract(File file, IPath location, Conflict prompt, IProgressMonitor monitor) throws IOException {
        if (ZipUtil.canDoNativeUnzip(prompt, null)) {
            return ZipUtil.nativeUnzip(file, location.toFile(), prompt, monitor);
        }
        return ZipUtil.extract(file, location.toFile(), prompt, null, monitor);
    }

    public static IStatus extract(File zipFile, File destinationPath, Conflict overwrite, IInputStreamTransformer transformer, IProgressMonitor monitor) throws IOException {
        if (ZipUtil.canDoNativeUnzip(overwrite, transformer)) {
            return ZipUtil.nativeUnzip(zipFile, destinationPath, overwrite, monitor);
        }
        ZipFile zip = new ZipFile(zipFile);
        return ZipUtil.extract(zip, zip.getEntries(), destinationPath, overwrite, transformer, monitor);
    }

    private static boolean canDoNativeUnzip(Conflict whatToDo, IInputStreamTransformer transformer) {
        if (transformer != null || PlatformUtil.isWindows() || whatToDo == Conflict.PROMPT) {
            return false;
        }
        IPath unzip = ExecutableUtil.find("unzip", false, null);
        return unzip.toFile().isFile();
    }

    private static IStatus nativeUnzip(File zip, File destination, Conflict overwrite, IProgressMonitor monitor) {
        String overwriteFlag = "-o";
        if (overwrite == Conflict.SKIP) {
            overwriteFlag = "-n";
        }
        return new ProcessRunner().run(null, null, null, CollectionsUtil.newList("unzip", overwriteFlag, zip.getAbsolutePath(), "-d", destination.getAbsolutePath()), monitor);
    }

    private static IStatus extract(ZipFile zip, File destinationPath, IProgressMonitor monitor) throws IOException {
        return ZipUtil.extract(zip, zip.getEntries(), destinationPath, monitor);
    }

    private static IStatus extract(ZipFile zip, File destinationPath, boolean overwrite, IProgressMonitor monitor) throws IOException {
        return ZipUtil.extract(zip, zip.getEntries(), destinationPath, overwrite ? Conflict.OVERWRITE : Conflict.SKIP, null, monitor);
    }

    public static InputStream openEntry(File zipFile, IPath path) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        ZipEntry entry = zip.getEntry(path.makeRelative().toPortableString());
        if (entry != null) {
            return zip.getInputStream(entry);
        }
        return null;
    }

    private static IStatus extract(ZipFile zip, Enumeration entries, File destinationPath, IProgressMonitor monitor) throws IOException {
        return ZipUtil.extract(zip, entries, destinationPath, Conflict.SKIP, null, monitor);
    }

    private static IStatus extract(ZipFile zip, Enumeration entries, File destinationPath, Conflict overwrite, IInputStreamTransformer transformer, IProgressMonitor monitor) throws IOException {
        ArrayList collection = Collections.list(entries);
        MultiStatus multiStatus = new MultiStatus("com.aptana.core", 0, null, null);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ZipUtil_default_extract_label, (int)collection.size());
        try {
            for (Object i : collection) {
                ZipEntry entry = (ZipEntry)i;
                ZipUtil.createDirectory(entry, destinationPath);
                if (!subMonitor.isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            HashSet<IPath> conflicts = new HashSet<IPath>();
            for (Object i : collection) {
                ZipEntry entry = (ZipEntry)i;
                IStatus fileStatus = ZipUtil.extractEntry(zip, entry, destinationPath, transformer, overwrite, (IProgressMonitor)subMonitor.newChild(1));
                if (fileStatus.getCode() == 128) {
                    conflicts.add(Path.fromPortableString((String)entry.getName()));
                } else {
                    multiStatus.merge(fileStatus);
                }
                if (!subMonitor.isCanceled()) continue;
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (overwrite == Conflict.PROMPT && !conflicts.isEmpty()) {
                Object result;
                Status status = new Status(4, "com.aptana.core", 128, Messages.ZipUtil_ConflictsError, null);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler != null && (result = handler.handleStatus((IStatus)status, conflicts)) instanceof IPath[]) {
                    IPath[] toOverwrite;
                    IPath[] iPathArray = toOverwrite = (IPath[])result;
                    int n = toOverwrite.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPath file = iPathArray[n2];
                        ZipEntry entry = zip.getEntry(file.toPortableString());
                        multiStatus.merge(ZipUtil.extractEntry(zip, entry, destinationPath, transformer, Conflict.OVERWRITE, (IProgressMonitor)subMonitor));
                        if (subMonitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ++n2;
                    }
                }
            }
            MultiStatus multiStatus2 = multiStatus;
            return multiStatus2;
        }
        catch (CoreException ce) {
            IStatus iStatus = ce.getStatus();
            return iStatus;
        }
        finally {
            subMonitor.done();
            ZipFile.closeQuietly((ZipFile)zip);
        }
    }

    private static void createDirectory(ZipEntry entry, File destinationPath) throws CoreException {
        String name = entry.getName();
        File file = new File(destinationPath, name);
        if (entry.isDirectory()) {
            ZipUtil.createDirectoryIfNecessary(file);
        } else if (name.indexOf(47) != -1) {
            ZipUtil.createDirectoryIfNecessary(file.getParentFile());
        }
    }

    private static void createDirectoryIfNecessary(File file) throws CoreException {
        if (!file.exists()) {
            if (IdeLog.isInfoEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/ziputil")) {
                IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Creating directory {0}", file.getAbsolutePath()), "com.aptana.core/debug/ziputil");
            }
            file.mkdirs();
        }
        if (!IOUtil.isWritableDirectory(file)) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.core", 130, MessageFormat.format(Messages.ZipUtil_ERR_NoWritePermission, file), null));
        }
    }

    private static IStatus extractEntry(ZipFile zip, ZipEntry entry, File destinationPath, IInputStreamTransformer transformer, Conflict howToResolve, IProgressMonitor monitor) {
        if (entry.isDirectory()) {
            return Status.OK_STATUS;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        String name = entry.getName();
        File file = new File(destinationPath, name);
        if (IdeLog.isInfoEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/ziputil")) {
            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Extracting {0} as {1}", name, file.getAbsolutePath()), "com.aptana.core/debug/ziputil");
        }
        subMonitor.setTaskName(String.valueOf(Messages.ZipUtil_extract_prefix_label) + name);
        subMonitor.worked(2);
        try {
            if (file.exists()) {
                switch (howToResolve) {
                    case OVERWRITE: {
                        if (IdeLog.isInfoEnabled(CorePlugin.getDefault(), "com.aptana.core/debug/ziputil")) {
                            IdeLog.logInfo(CorePlugin.getDefault(), MessageFormat.format("Deleting a file/directory before overwrite {0}", file.getAbsolutePath()), "com.aptana.core/debug/ziputil");
                        }
                        FileUtil.deleteRecursively(file);
                        break;
                    }
                    case SKIP: {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    case PROMPT: {
                        Status status = new Status(1, "com.aptana.core", 128, name, null);
                        return status;
                    }
                }
            }
            subMonitor.setWorkRemaining(95);
            ZipUtil.extractFile(zip, entry, destinationPath, file, transformer, (IProgressMonitor)subMonitor.newChild(95));
        }
        finally {
            subMonitor.done();
        }
        return Status.OK_STATUS;
    }

    private static IStatus extractFile(ZipFile zip, ZipEntry entry, File destinationPath, File file, IInputStreamTransformer transformer, IProgressMonitor monitor) {
        if (ZipUtil.isSymlink(entry)) {
            return ZipUtil.extractSymlink(zip, entry, destinationPath, file);
        }
        OutputStream out = null;
        InputStream in = null;
        try {
            try {
                file.getParentFile().mkdirs();
                in = zip.getInputStream(entry);
                if (transformer != null) {
                    in = transformer.transform(in, Path.fromPortableString((String)entry.getName()));
                }
                out = new FileOutputStream(file);
                IOUtil.pipe(in, out);
            }
            catch (ZipException e) {
                Status status = new Status(4, "com.aptana.core", 0, MessageFormat.format("Error getting input stream for zip entry {0}", entry.getName()), (Throwable)e);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return status;
            }
            catch (IOException e) {
                Status status;
                block32: {
                    status = new Status(4, "com.aptana.core", 0, MessageFormat.format("IOException while extracting file {0}", file.getAbsolutePath()), (Throwable)e);
                    if (in == null) break block32;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return status;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        int unixMode = entry.getUnixMode();
        if (!PlatformUtil.isWindows() && unixMode != 0) {
            String permString = Integer.toOctalString(unixMode & 0xFFF);
            return FileUtil.chmod(permString, file);
        }
        return Status.OK_STATUS;
    }

    private static IStatus extractSymlink(ZipFile zip, ZipEntry entry, File destinationPath, File file) {
        if (!PlatformUtil.isWindows()) {
            try {
                file.getParentFile().mkdirs();
                String target = IOUtil.read(zip.getInputStream(entry), "UTF-8");
                return new ProcessRunner().runInBackground("ln", "-s", new File(destinationPath, target).getAbsolutePath(), file.getAbsolutePath());
            }
            catch (ZipException e) {
                return new Status(4, "com.aptana.core", 0, MessageFormat.format("Error getting input stream for zip entry {0}", entry.getName()), (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "com.aptana.core", 0, MessageFormat.format("IOException while extracting file {0}", file.getAbsolutePath()), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public static boolean compress(String destination, String[] sourceFiles) {
        return ZipUtil.compress(destination, sourceFiles, null);
    }

    public static boolean compress(String destination, String[] sourceFiles, String sourcePathRoot) {
        if (!StringUtil.isEmpty(destination)) {
            try {
                ZipOutputStream output = new ZipOutputStream(new FileOutputStream(destination));
                ZipUtil.addToZip(sourceFiles, sourcePathRoot, output);
                output.close();
                return true;
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), MessageFormat.format("Error creating zip {0}", destination), e);
            }
        }
        return false;
    }

    private static void addToZip(String[] sourceFiles, String sourcePathRoot, ZipOutputStream output) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        String[] stringArray = sourceFiles;
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File content = new File(file);
            if (content.isDirectory()) {
                File[] children = content.listFiles();
                String[] childrenPaths = new String[children.length];
                int i = 0;
                while (i < children.length) {
                    childrenPaths[i] = children[i].getAbsolutePath();
                    ++i;
                }
                ZipUtil.addToZip(childrenPaths, sourcePathRoot, output);
            } else if (content.canRead()) {
                int length;
                FileInputStream input = new FileInputStream(file);
                String name = sourcePathRoot == null ? file : Path.fromOSString((String)file).makeRelativeTo(Path.fromOSString((String)sourcePathRoot)).toOSString();
                output.putNextEntry(new java.util.zip.ZipEntry(name));
                while ((length = input.read(buffer)) > 0) {
                    output.write(buffer, 0, length);
                }
                output.closeEntry();
                input.close();
            }
            ++n2;
        }
    }

    private static boolean isSymlink(ZipEntry entry) {
        return (entry.getUnixMode() & 0xA000) == 40960;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Conflict {
        OVERWRITE,
        PROMPT,
        SKIP;

    }

    public static interface IInputStreamTransformer {
        public InputStream transform(InputStream var1, IPath var2);
    }
}

